/* 
 * checkmail.c 
 *
 * Періодично перевіряє стан поштової скриньки користувача 
 * і видає повідомлення про надходження нових листів, коли 
 * виявляє збільшення її розміру.
 * Ілюструє порядок оперування атрибутами файлів.
 *
 */

#include <errno.h>
#include <pwd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

/* Каталог із поштовими скриньками */
#define MAILDIR                 "/var/spool/mail"


int main (int argc, char *argv[])
{
        struct passwd *pw;
        struct stat st;
        int prev_size = 0;      /* Попередній розмір поштової скриньки */

        /* Отримує ім'я користувача. */
        pw = getpwuid(getuid());
        if (pw == NULL) {
                fprintf(stderr, "Error getting login name: %s\n",
                                                        strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Робить каталог MAILDIR поточним. */
        if (chdir(MAILDIR) != 0) {
                fprintf(stderr, "Error changing current directory to"
                                " %s: %s\n", MAILDIR, strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Робочий цикл */
        for (;;) {
                /* Отримує атрибути поштової скриньки (ім'я поштової
                   скриньки збігається з іменем користувача). 
                   Порівнює поточний розмір поштової скриньки з попереднім.
                   Якщо розмір став більше, виводить повідомлення. */
                
                /* ... */

                /* Трошки спить. */
		sleep(10);    
        }
}
